;| c:acmLayHigh

Auswahl eines Objekts leuchtet alle Objekte desselben Layers aus.
Zustzliche in Infos in Alert-Box und der Befehlszeile:

Layername und -Eigenschaften Farbe & Linientyp
Anzahl der verschiedenen Objektarten auf diesem Layer


Plattform: ab AutoCAD 2020

Copyright
Markus Hoffmann, www.CADmaro.de

Januar 2023
|;
(defun c:acmLayHigh (/ s ss aLayer ss1)
  (mx:Init)
  (while
    (setq s (car (entsel "\nObjekt whlen fr Layerauswahl: ")))
     (if
       (setq ss
              (ssget "_X"
                     (list
                       (setq aLayer
                              (assoc 8 (entget s))
                       )
                     )
              )
       )
        (progn
          (if ss1
            (progn
              (mapcar
                '(lambda (e)
                   (redraw e 4)
                 )
                (mx:SelectionSet->EList ss1)
              )
              (setq ss1 nil)
            )
          )
          (setq l
                 (mapcar
                   '(lambda (e)
                      (cdr (assoc 0 (entget e)))
                    )
                   (mx:SelectionSet->EList ss)
                 )
          )
          (setq lCounted
                 (LM:CountItems
                   (vl-sort l '<)
                 )
          )
          (setq lSorted
                 (vl-sort
                   lCounted
                   '(lambda (e1 e2)
                      (>
                        (cdr e1)
                        (cdr e2)
                      )
                    )
                 )
          )
          (setq oLayer (vla-item (vla-get-layers oAD) (cdr aLayer)))
          (setq ToPrinc
                 (strcat
                   "Layer: "
                   (cdr aLayer)
                   "\nLayerfarbe: "
                   (itoa (vla-get-Color olayer))
                   "\nLayerlinientyp: "
                   (vla-get-Linetype olayer)
                   "\n\nObjektanzahl auf Layer: "
                   (itoa (sslength ss))
                   "\n\nAnzahl je Objektart auf diesem Layer:"
                   (apply
                     'strcat
                     (mapcar
                       '(lambda (l)
                          (strcat
                            "\n"
                            (car l)
                            ": "
                            (itoa (cdr l))
                          )
                        )
                       lSorted
                     )
                   )
                 )
          )
          (if (= 1 (getvar "CMDDIA"))
            (alert
              (strcat
                ToPrinc
                "\n\nDie Objekte werden nach dem Schlieen dieses Dialogs ausgeleuchtet."
              )
            )
          )
          (mapcar
            '(lambda (e)
               (redraw e 3)
             )
            (mx:SelectionSet->EList (setq ss1 ss))
          )
          (princ ToPrinc)
        )
     )
  )
  (sssetfirst nil ss1)
  (princ "\nAlle Objekte des Layers sind ausgewhlt!\n")
  (mapcar
    '(lambda (e)
       (redraw e 4)
     )
    (mx:SelectionSet->EList ss1)
  )
  (mx:Reset)
  (princ)
)

 ;| mx:SelectionSet->EList

Auswahlsatz in Liste umwandeln
|;
(defun mx:SelectionSet->EList (ss / c lst)
  (repeat
    (setq c (sslength ss))
     (setq lst
            (cons
              (ssname ss (setq c (1- c)))
              lst
            )
     )
  )
)

;; Count Items  -  Lee Mac
;; Returns a list of dotted pairs detailing the number of
;; occurrences of each item in a supplied list.
(defun LM:CountItems (l / c x)
  (if
    (setq x (car l))
     (progn
       (setq c (length l)
             l (vl-remove x (cdr l))
       )
       (cons
         (cons
           x
           (- c (length l))
         )
         (LM:CountItems l)
       )
     )
  )
)

 ;| mx:Init

Initialisierung
|;
(defun mx:Init ()
  (vl-load-com)
  (setq oAD
         (vlax-get-property
           (vlax-get-acad-object)
           'ActiveDocument
         )
  )
  (setq iEcho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq iLight (getvar "HIGHLIGHT"))
  (setvar "HIGHLIGHT" 1)
  (setq errorMX *error*
        *error* mx:Error
  )
  (vlax-invoke-method oAD 'EndUndomark)
  (vlax-invoke-method oAD 'StartUndomark)
)

 ;| mx:Reset

Zurcksetzen
|;
(defun mx:Reset ()
  (vla-regen oAD acAllViewports)
  (setvar "CMDECHO" iEcho)
  (setvar "HIGHLIGHT" iLight)
  (vlax-invoke-method oAD 'EndUndomark)
  (vlax-release-object oAD)
  (setq *error* errorMX)
  (mapcar
    '(lambda (arg)
       (set
         arg
         'nil
       )
     )
    (list 'errorMX 'iEcho 'iLight 'oAD 'lSelected)
  )
)

 ;| mx:Error

Errorfunktion
|;
(defun mx:Error (s)
  (print (strcat "Fehler " s))
  (command-s)
  (command-s
    "_.undo"
    "_back"
  )
  (mx:Reset)
  (princ)
)

;;; Befehl ohne alert-Box
(defun c:-acmLayHigh (/ iDIA)
  (setq iDIA (getvar "CMDDIA"))
  (setvar "CMDDIA" 0)
  (c:acmLayHigh)
  (setvar "CMDDIA" iDIA)
  )

;;; Kurzbefehl
(defun c:acmLaHi () (c:acmLayHigh))

;;; Kurzbefehl ohne alert-Box
(defun c:-acmLaHi () (c:-acmLayHigh))

;; Feedback beim Laden
(princ
  "\nacmLayHigh wurde geladen. Copyright M.Hoffmann, www.CADmaro.de.
Start mit \"acmLayHigh\" oder \"acmLaHi\", bzw. mit vorangestelltem Minuszeichen fr die Befehlszeilenversion."
)
(princ)